import React from 'react';
import * as icons from 'lucide-react';
import { SavingsCategory } from '../types';

interface CategoryCardProps {
  category: SavingsCategory;
}

export function CategoryCard({ category }: CategoryCardProps) {
  // Get the correct icon component by capitalizing first letter
  const iconName = category.icon.split('-').map(word => 
    word.charAt(0).toUpperCase() + word.slice(1)
  ).join('');
  const IconComponent = (icons as any)[iconName];

  if (!IconComponent) {
    console.warn(`Icon ${category.icon} not found`);
    return null;
  }

  return (
    <div className="bg-white rounded-lg shadow-md overflow-hidden transition-transform hover:scale-105">
      <div className="h-48 overflow-hidden">
        <img
          src={category.imageUrl}
          alt={category.title}
          className="w-full h-full object-cover"
        />
      </div>
      <div className="p-4">
        <div className="flex items-center gap-2 mb-2">
          <IconComponent className="w-5 h-5 text-blue-600" />
          <h3 className="text-lg font-semibold text-gray-800">{category.title}</h3>
        </div>
        <p className="text-gray-600 text-sm">{category.description}</p>
      </div>
    </div>
  );
}